import numpy as np
import matplotlib.pyplot as plt
width = 0.5

colum1 = [0.4994312793150643, 0.4951454172524352, 0.4911603205769501, 0.49776212269875003, 0.49716862655829214,
     0.4953389639836637, 0.4985403053202497, 0.4989418133007021, 0.4978155871759747, 0.4956648466720387,
     0.5004101882175809, 0.5006869935200371, 0.5006110670585818, 0.4957967559488993, 0.4926150923101271]

colum2 = [0.49059220572714063, 0.49803420967002554, 0.4925552098819826, 0.493856695886948, 0.49136820334756376,
     0.5055461967985895, 0.4879405839377042, 0.49763509776046216, 0.4935488049382133, 0.49931135803721033,
     0.49944527295895286, 0.49368951097727026, 0.4946145209131254, 0.49937228838636005, 0.4954167748616922]

colum3 = [0.49635205350930195, 0.4981377156366946, 0.4965410422152118, 0.4990371497213606, 0.4935092644125994,
     0.5010364091389291, 0.5032992423260794, 0.4917576855514701, 0.49973433120449134, 0.501626494994708,
     0.4926592057982831, 0.4964481699534255, 0.49605448660363916, 0.49825442879541954, 0.49496153945653626]

colum4 = [0.49626061791884524, 0.4986537872362349, 0.5002314885085182, 0.4980700923826377, 0.4913903446317532,
     0.4982301048759133, 0.49906957870391916, 0.4956589391916223, 0.4968474336050135, 0.497166137555265,
     0.49844397483019554, 0.5051732980242588, 0.49387564996996713, 0.49929240872389435, 0.4984584449624436]
colum = [colum1,colum2,colum3,colum4]
btm = [0.475,0.475,0.475, 0.475]

labels = ['0.8', '0.85', '0.9', '0.95']
x = np.arange(len(labels))

fig, ax = plt.subplots()
size = 12
ax.tick_params(axis='both', which='major', labelsize=size)
ax.tick_params(axis='both', which='minor', labelsize=size)
plt.rc('font', size=size)
plt.rc('axes', titlesize=size)
plt.rc('axes', labelsize=size)
plt.rc('xtick', labelsize=10)
plt.rc('ytick', labelsize=size)
plt.rc('legend', fontsize=14)
plt.rc('figure', titlesize=size)
ax.bar(x, btm, width, label="Theoretical", edgecolor='k', color = '#929591')

for i in range(15):
    scy = []
    for j in x:
        scy.append(colum[j][i])
    if i == 0:
        ax.scatter(x, scy, color='#E50000', edgecolor='k', marker='o', zorder=1, label="Experimental")
    else:
        ax.scatter(x, scy, color='#E50000', edgecolor='k', marker='o', zorder=1)
ax.bar(x, 1, width, edgecolor='k', zorder=0, color = '#FAC205')
ax.set_ylabel(r"$\mathbb{E}\left[ALG\right]$ / $\max$ OPT", fontsize=18)
ax.set_xlabel(r"$\frac{1}{L}\sum_l\ \sum_t\mathbb{E}[r_{t,l}]/K$", fontsize=18)

ax.set_xticks(x)
ax.set_xticklabels(labels)
ax.legend(ncol=3, loc='lower center', bbox_to_anchor=(0.5, 1))
ax.set_ylim(0.35, 0.53)
plt.rcParams["font.family"] = "Times New Roman"
plt.rc('pdf',fonttype = 42)
plt.rc('ps',fonttype = 42)

plt.style.use('classic')
plt.tight_layout()
figure = plt.gcf()
figure.savefig("Set1-2.pdf")
plt.show()